#==============================================================================
#  Window_Title_Menu
#------------------------------------------------------------------------------
# cpp^Cgj[EBhE
# Copyright (C) 2005 fukuyama
#==============================================================================

module DQ
  
  class Window_Title_Menu < ::DQ::Window_Page_Menu
    include Window_Tree_Module
    
    def initialize
      add_menu(TITLE_CONTINUE_LABEL, :command_continue)
      add_menu(TITLE_NEW_GAME_LABEL, :command_new_game)
      add_menu(TITLE_DELETE_GAME_LABEL, :command_delete_game)
      @index = 0
      unless SaveData_Facade.exist_index?
        @index = 1
      end
      super(nil)
      self.x = 16
      self.y = 16
      @text = ''
    end
    
    def update
      super
      if not @window_input.nil?
        if @window_input.disposed?
          if @window_input.text != ''
            window = Window_SaveData_Create.new(self,@window_input.text)
            set_active_window(window.class)
          end
          @window_input = nil
        end
      end
    end
    
    def command_new_game
      @window_input = Window_InputString.new(TITLE_INPUT_NAME_LABEL,INPUT_NAME_MAX_SIZE)
      @window_input.back_opacity = WINDOW_BACK_OPACITY
      @window_input.window_input_area.back_opacity = WINDOW_BACK_OPACITY
      add_child @window_input
      set_active_window(@window_input.class)
      @window_input.window_input_area.y = 16
      @window_input.y -= 32
    end
    
    def command_continue
      window = Window_SaveData_Continue.new(self)
      window.index = SaveData_Facade.latest_save_index()
      set_active_window(window.class)
    end
    
    def command_delete_game
      window = Window_SaveData_Delete.new(self)
      set_active_window(window.class)
    end
  end
  
end
